#include <stdio.h>
#include <stdlib.h>

typedef struct {
    long long x;
    long long y;
    int index;
} Vector;

int half(const Vector *v) {
    if (v->y > 0) return 0;
    if (v->y == 0 && v->x > 0) return 0;
    return 1;
}

long long cross(const Vector *a, const Vector *b) {
    return a->x * b->y - a->y * b->x;
}

long long dot(const Vector *a, const Vector *b) {
    return a->x * b->x + a->y * b->y;
}

int cmp(const void *a, const void *b) {
    const Vector *A = a;
    const Vector *B = b;
    int ha = half(A);
    int hb = half(B);
    if (ha != hb) return ha - hb;
    long long c = cross(A, B);
    if (c > 0) return -1;
    if (c < 0) return 1;
    return 0;
}

long long sq(long long x) {
    return x * x;
}

int main() {
    int n;
    scanf("%d", &n);

    Vector *v = malloc(n * sizeof(Vector));
    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &v[i].x, &v[i].y);
        v[i].index = i + 1;
    }

    qsort(v, n, sizeof(Vector), cmp);

    Vector *d = malloc(2 * n * sizeof(Vector));
    for (int i = 0; i < n; i++) {
        d[i] = v[i];
        d[i + n] = v[i];
    }

    long long best = 0, sx = 0, sy = 0;
    int l = 0, bl = -1, br = -1;

    for (int r = 0; r < 2 * n; r++) {
        sx += d[r].x;
        sy += d[r].y;

        while (l <= r && (
            r - l + 1 > n ||
            cross(&d[l], &d[r]) < 0 ||
            (cross(&d[l], &d[r]) == 0 && dot(&d[l], &d[r]) < 0)
        )) {
            sx -= d[l].x;
            sy -= d[l].y;
            l++;
        }

        long long val = sq(sx) + sq(sy);
        if (val > best) {
            best = val;
            bl = l;
            br = r;
        }
    }

    if (best == 0) {
        printf("0\n\n");
    } else {
        printf("%d\n", br - bl + 1);
        for (int i = bl; i <= br; i++) {
            printf("%d%s", d[i].index, i == br ? "" : " ");
        }
        printf("\n");
    }

    free(v);
    free(d);
    return 0;
}